<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {

        if (Schema::hasColumn('tracks', 'price')) {
            Schema::table('tracks', function (Blueprint $table) {
                $table->dropColumn('price');
            });
        }

        Schema::table('tracks', function (Blueprint $table) {
            $table->string('price')->nullable()->after('end_time');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tracks', function (Blueprint $table) {
            $table->dropColumn('price');
        });
    }
};
